program remove ;

{ remove a player or game from Eclectic Avenue data files }

uses dos, remdef, crt ;

var
   newuser                    : file of userrecord ;
   TempGameFile               : File of gamerecord ;
   k,j                        : integer ;
   a                          : char ;


FUNCTION Julian( year : INTEGER; mon, day : BYTE): REAL;
var
  temp        : real;
begin                                      { function Julian                 }
  if (year < 0) OR (mon < 1) OR (day < 1) OR (day > 31) then
    begin
      Julian := -1;
      exit;
    end;  { IF }
  if year < 100 then
    year := year + 1900;
  temp := int((mon - 14.0) / 12.0);
  Julian := day - 32075.0 +
            int(1461.0 * (year + 4800.0 + temp) / 4.0) +
            int(367.0 * (mon - 2.0 - temp * 12.0) / 12.0) -
            int(3.0 * int((year + 4900.0 + temp) / 100.0) / 4.0)
end;


FUNCTION Exist(InFile:PathStr):BOOLEAN ;
VAR
  TestFile : Searchrec ;
BEGIN
{$I-}
  FindFirst(InFile,ANYFILE,TestFile) ;
  IF DosError = 0 THEN Exist := TRUE ELSE Exist := FALSE ;
{$I+}
END ;



FUNCTION LTrim(A:String): String;
Begin
  While A[1] = ' ' Do
  Begin
    Delete(A,1,1);
    If A = '' then
    Begin
      LTrim := '';
      Exit;
    End;
  End;
  LTrim := A;
End;



FUNCTION RTrim(A:String): String;
Begin
  While A[Length(A)] = ' ' Do
  Begin
    Delete(A,Length(A),1);
    If A = '' then
    Begin
      RTrim := '';
      Exit;
    End;
  End;
  RTrim := A;
End;


function changecase(instr:string) : string ;
var
   i                          : byte ;
begin
   for i := 1 to length(instr) do instr[i] := upcase(instr[i]) ;
   changecase := instr ;
end ;

Procedure WriteList ;
VAR
   i       : Byte ;
   holding : CHAR ;
BEGIN
   IF NOT Exist('EA.dat') THEN BEGIN
      WRITELN(' There are no players!') ;
      Exit ;
   END ;
   ASSIGN(userfile,'EA.dat') ;
   RESET(userfile) ;
   IF FileSize(UserFile) < 1 THEN BEGIN
      WRITELN(' There are no players!') ;
      CLOSE(UserFile) ;
      Exit ;
   END ;
   i := 0 ;
   WRITELN ;
   WHILE NOT EOF(userfile) DO BEGIN
      READ(UserFile,User) ;
      INC(i) ;
      TextColor(3) ;
      WRITE('Name: ') ;
      Textcolor(11) ;
      Write(User.Name);
      TextColor(3) ;
      gotoxy(43,wherey) ;
      WRITE('Alias: ') ;
      TextColor(11) ;
      Writeln(User.Alias) ;
      TextColor(3) ;
      IF i MOD 24 = 0 THEN BEGIN
         TextColor(4) ;
         WRITE('-=More=-') ;
         holding := READKEY ;
         WRITELN ;
      END ;
   END ;
   CLOSE(UserFile) ;
END ;


FUNCTION GetNameToDelete : STRING ;
VAR
   t                          : STRING ;
   a                          : CHAR ;
BEGIN
   REPEAT
      writeln ;
      TextColor(9) ;
      write('Enter player ALIAS, ''LIST'' for list, or <ENTER> to quit: ') ;
      readln(t) ;
      if t = '' then BEGIN
         ClrScr ;
         GetNameToDelete := '' ;
         Exit ;
      END ;
      t := changecase(t) ;
      If t = 'LIST' then WriteList ;
   UNTIL t <> 'LIST' ;
   t := LTrim(RTrim(changecase(t))) ;
   writeln ;
   TextColor(12) ;
   write('Remove ',t,'? [y,n]: ') ;
   repeat
      a := upcase(readkey) ;
   until a in ['Y','N'] ;
   writeln(a) ;
   if a = 'N' then BEGIN
      GetNameToDelete := '' ;
      Exit ;
   END ;
   writeln ;
   GetNameToDelete := t ;
END ;



PROCEDURE NukeMail(tstr:STRING) ;
VAR
   j                          : BYTE ;
   tfile                      : TEXT ;
BEGIN
   TextColor(11) ;
   WriteLn('Removing messages to/from ',tstr) ;
   ASSIGN(MsgFile,'EA.msg') ;
   {$I-} RESET(MsgFile) ; {$I+}
   If IOResult <> 0 Then Exit ;
   WHILE Not EOF(MsgFile) do begin
      READ(MsgFile,Msg) ;
      If Msg.WhoTo = tstr Then Begin
         With Msg do Begin
            WhoTo := '' ;
            From := '' ;
            Subject := '' ;
            Dtg := '' ;
            Assign(tfile,FileName) ;
            Erase(tfile) ;
            FileName := '' ;
         End ;
         Seek(MsgFile,FilePos(MsgFile)-1) ;
         Write(MsgFile,Msg) ;
      END ;
   END ;
   Close(MsgFile) ;
END ;



PROCEDURE DoTheDirtyWork(tstr:STRING) ;
VAR
   j                          : BYTE ;
   PlayerExist                : BOOLEAN ;
BEGIN
   IF tstr = '' THEN Exit ;
   ASSIGN(gamefile,'EA.gam') ;
   {$I-} RESET(gamefile) ; {$I+}
   IF IOResult <> 0 THEN BEGIN
      WRITELN(' Could not open the game file!') ;
      DELAY(3000) ;
      Exit ;
   END ;
   IF FileSize(GameFile) < 1 THEN BEGIN
      CLOSE(GameFile) ;
   END ELSE BEGIN
      WHILE Not EOF(Gamefile) do begin
         READ(GameFile,GameInfo) ;
         FOR j := 1 to 33 do begin
            IF Gameinfo.Gamedata[j].owner = tstr then begin
               Gameinfo.Gamedata[j].owner := '' ;
               GameInfo.GameData[j].SellPrice := 0 ;
            END ;
         END ;
         SEEK(GameFile,FilePos(GameFile)-1) ;
         WRITE(GameFile,GameInfo) ;
         FOR j := 1 to 8 do begin
            WITH GameInfo DO BEGIN
               IF PlayerName[j] = tstr then begin
                  Writeln('Removing ',tstr,' from game number: ',filepos(GameFile)) ;
                  PlayerName[j] := '' ;
                  PlayerScore[j] := 0 ;
                  TurnCount[j]   := 0 ;
                  PlayerSquareNumber[j] := 1 ;
                  LastDate[j] := '' ;
                  OutOfGame[j] := false ;
                  InJail[j] := false ;
                  GetOutOfJail[j] := false ;
                  SEEK(GameFile,FilePos(GameFile)-1) ;
                  WRITE(GameFile,GameInfo) ;
               END;
            END ;
         END;
      END;
   END ;
   WriteLn('Removing ',tstr,' from player data file...') ;
   ASSIGN(UserFile,'EA.dat') ;
   RESET(UserFile) ;
   ASSIGN(NewUser,'EA.$$$') ;
   REWRITE(NewUser) ;
   PlayerExist := False ;
   WHILE Not EOF(UserFile) do begin
      READ(UserFile,User) ;
      IF User.Alias <> tstr then WRITE(NewUser,User)
         ELSE PlayerExist := True ;
   END ;
   CLOSE(UserFile) ;
   CLOSE(NewUser) ;
   ERASE(UserFile) ;
   RENAME(NewUser,'EA.dat') ;
   nukemail(tstr) ;
   IF PlayerExist THEN writeln(tstr,' has been removed from the game.')
      ELSE writeln('There was no such alias as: ',tstr) ;
   writeln ;
END ;


PROCEDURE KillGame ;
Var
   tstr                       : string ;
   a                          : byte ;
   code                       : integer ;
BEGIN
   Assign(GameFile,'EA.Gam') ;
   {$I-} Reset(GameFile) ; {$I+}
   IF IOResult <> 0 THEN BEGIN
      WRITELN(' Could not open the game file!') ;
      DELAY(3000) ;
   END ;
   REPEAT
      WriteLn;
      TextColor(14) ;
      If FileSize(GameFile) < 1 Then
         Write('There are no games to delete. Press <ENTER> to continue.')
      Else
         Write('Enter game number to remove [1..',FileSize(GameFile),']: ') ;
      ReadLn(tstr) ;
      IF tstr = '' THEN BEGIN
        ClrScr ;
         Exit ;
      End ;
      VAL(tstr,a,code) ;
   UNTIL (a > 0) AND (a <= FileSize(GameFile)) AND (code = 0) ;
   Assign(TempGameFile,'EAGam.$$$') ;
   {$I-} ReWrite(TempGameFile) ; {$I+}
   IF IOResult <> 0 THEN BEGIN
      WRITELN(' Could not open EAGAM.$$$!') ;
      DELAY(3000) ;
      CLOSE(GameFile) ;
      Exit ;
   END ;
   While Not EOF(GameFile) do Begin
      Read(GameFile,GameInfo) ;
      If FilePos(GameFile) <> a Then Write(TempGameFile,GameInfo)
         ELSE
      WriteLn('Found and removed game number ',a) ;
   End ;
   Close(TempGameFile) ;
   Close(GameFile) ;
   Erase(GameFile) ;
   ReName(TempGameFile,'EA.gam') ;
   WriteLn ;
 END ;


BEGIN {MAIN BODY}
   ClrScr ;
   REPEAT
      writeln ;
      TextColor(2) ;
      writeln('Eclectic Avenue Player Removal Utility For Version 2.0') ;
      writeln('Written by John Parlin for Eclectic Avenue 2.0') ;
      writeln ;
      textcolor(12) ;
      write('NOTE:  ') ;
      textcolor(15) ;
      writeln('This utility will remove a player or a game from the') ;
      writeln('       appropriate database.  Therefore, Eclectic Avenue should') ;
      textcolor(14) ;
      write('       NOT') ;
      textcolor(15) ;
      writeln(' be in use while using this utility.') ;
      WriteLn ;
      TextColor(10) ;
      Write('Enter ''G'' to delete game, ''P'' to delete player or ''X'' to exit: ') ;
      Repeat
        a := upcase(readkey) ;
      Until a in ['P','G','X'] ;
      WriteLn(a) ;
      ClrScr ;
      If a = 'X' then Halt(99) ;
      If a = 'P' Then DoTheDirtyWork(GetNameToDelete) ELSE KillGame ;
      WriteLn ;
   UNTIL a = 'X' ;
   TextColor(7) ;
END.
