UNIT Play ;

INTERFACE

USES DOS,CRT,JPDoor32,EADef,EASup,EAUtils,Darts,Dungeon ;

PROCEDURE PlayGame(Gnum:BYTE) ;
PROCEDURE PropertySummary(n:BYTE) ;
PROCEDURE ShowBoard(n:BYTE) ;
PROCEDURE ShowPastGames ;
PROCEDURE ShowBoardAgent ;
PROCEDURE ViewTournament ;
PROCEDURE WriteThisGame ;
PROCEDURE ReadThisGame(WriteFirst:BOOLEAN) ;

IMPLEMENTATION

VAR
   PlayerNumber              : BYTE ;
   SavedScore                : LONGINT ;
   OwnerSex                  : CHAR ;
   hr,mn,sec,sec100          : WORD ;
   EABoardName               : STRING ;
   EatIsOn                   : BOOLEAN ;
   RobIsOn                   : BOOLEAN ;
   DartsOn                   : BOOLEAN ;
   GambleOn                  : BOOLEAN ;
   DungeonOn                 : BOOLEAN ;
   NumberOfPlayers           : BYTE ;
   SecretSquare              : BYTE ;
   Turns                     : BYTE ;
   falling                   : BOOLEAN ;
   x,y                       : BYTE ;
   lastlistpos               : INTEGER ;

PROCEDURE WriteThisGame ;
BEGIN
   GameInfo.PlayerScore[PlayerNumber] := PlayerScore ;
   GameInfo.TurnCount[PlayerNumber] := TurnCount ;
   GameInfo.PlayerSquareNumber[PlayerNumber] := PlayerSquareNumber ;
   GameInfo.LastDate[PlayerNumber] := LastDate ;
   GameInfo.OutOfGame[PlayerNumber] := OutOfGame ;
   GameInfo.InJail[PlayerNumber] := InJail ;
   GameInfo.GetOutOfJail[PlayerNumber] := GetOutOfJail ;
   GameInfo.DartScore[PlayerNumber] := DartScore ;
   fn := 'EA.GAM' ;
   ASSIGN(GameFile,fn) ;
   RESET(GameFile) ;
   SEEK(GameFile,GameNumber-1) ;
   WRITEGame ;
   CLOSE(GameFile) ;
END ;


PROCEDURE ReadThisGame(WriteFirst:BOOLEAN) ;
BEGIN
   IF WriteFirst THEN WriteThisGame ;
   fn := 'EA.GAM' ;
   ASSIGN(GameFile,fn) ;
   RESET(GameFile) ;
   SEEK(GameFile,GameNumber-1) ;
   READGame ;
   CLOSE(GameFile) ;
END ;


PROCEDURE WriteMsg(color:byte;tstr:STRING) ;
BEGIN
   CursorPos(20,1) ;
   sDisplay(0,color,0,tstr) ;
END ;


PROCEDURE PutPlayer(n:BYTE) ;
BEGIN
   CASE n OF
      1 : CursorPos(6,2) ;
      2 : CursorPos(3,2) ;
      3 : CursorPos(3,9) ;
      4 : CursorPos(3,14) ;
      5 : CursorPos(3,20) ;
      6 : CursorPos(3,26) ;
      7 : CursorPos(3,32) ;
      8 : CursorPos(3,37) ;
      9 : CursorPos(3,43) ;
      10: CursorPos(3,49) ;
      11: CursorPos(3,54) ;
      12: CursorPos(3,60) ;
      13: CursorPos(3,65) ;
      14: CursorPos(3,73) ;
      15: CursorPos(6,73) ;
      16: CursorPos(9,73) ;
      17: CursorPos(12,73) ;
      18: CursorPos(15,73) ;
      19: CursorPos(18,73) ;
      20: CursorPos(18,65) ;
      21: CursorPos(18,60) ;
      22: CursorPos(18,53) ;
      23: CursorPos(18,46) ;
      24: CursorPos(18,40) ;
      25: CursorPos(18,32) ;
      26: CursorPos(18,27) ;
      27: CursorPos(18,22) ;
      28: CursorPos(18,14) ;
      29: CursorPos(18,9) ;
      30: CursorPos(18,2) ;
      31: CursorPos(15,2) ;
      32: CursorPos(12,2) ;
      33: CursorPos(9,2) ;
   END ;
   sDisplay(0,15,0,' ') ;
   CASE n OF
      1 : CursorPos(3,2) ;
      2 : CursorPos(3,9) ;
      3 : CursorPos(3,14) ;
      4 : CursorPos(3,20) ;
      5 : CursorPos(3,26) ;
      6 : CursorPos(3,32) ;
      7 : CursorPos(3,37) ;
      8 : CursorPos(3,43) ;
      9 : CursorPos(3,49) ;
      10: CursorPos(3,54) ;
      11: CursorPos(3,60) ;
      12: CursorPos(3,65) ;
      13: CursorPos(3,73) ;
      14: CursorPos(6,73) ;
      15: CursorPos(9,73) ;
      16: CursorPos(12,73) ;
      17: CursorPos(15,73) ;
      18: CursorPos(18,73) ;
      19: CursorPos(18,65) ;
      20: CursorPos(18,60) ;
      21: CursorPos(18,53) ;
      22: CursorPos(18,46) ;
      23: CursorPos(18,40) ;
      24: CursorPos(18,32) ;
      25: CursorPos(18,27) ;
      26: CursorPos(18,22) ;
      27: CursorPos(18,14) ;
      28: CursorPos(18,9) ;
      29: CursorPos(18,2) ;
      30: CursorPos(15,2) ;
      31: CursorPos(12,2) ;
      32: CursorPos(9,2) ;
      33: CursorPos(6,2) ;
   END ;
   sDisplay(1,14,1,#1) ;
END ;


FUNCTION FreeSquare : INTEGER ;
VAR
   i      : BYTE ;
   tstr   : STRING ;
BEGIN
   tstr := '' ;
   REPEAT
      ClearStatusArea ;
      TenButtons ;
      CursorPos(20,1) ;
      sDisplay(0,14,1,'FREE SQUARE!') ;
      CursorPos(22,1) ;
      sDisplay(0,11,0,'Enter the square number you would like to move to: ') ;
      tstr := GetInput('',0,2) ;
      i := AtoI(tstr) ;
   UNTIL (i > 0) AND (i < 34) ;
   ClearStatusArea ;
   CursorPos(20,1) ;
   sDisplay(0,14,0,'MOVING...') ;
   FreeSquare := i ;
END ;


PROCEDURE CP(cy,cx:BYTE) ;
BEGIN
   CursorPos(cy,cx) ;
   x := cx ;
   y := cy ;
END ;


PROCEDURE PutCursor(i:BYTE) ;
BEGIN
   CASE i OF
      2 : CP(3,11) ;
      3 : CP(3,17) ;
      4 : CP(3,23) ;
      6 : CP(3,34) ;
      7 : CP(3,40) ;
      8 : CP(3,46) ;
      9 : CP(3,51) ;
      10 : CP(3,57) ;
      11 : CP(3,62) ;
      12 : CP(3,70) ;
      19 : CP(18,70) ;
      20 : CP(18,62) ;
      21 : CP(18,57) ;
      22 : CP(18,50) ;
      24 : CP(18,37) ;
      25 : CP(18,29) ;
      26 : CP(18,24) ;
      27 : CP(18,19) ;
      28 : CP(18,11) ;
      30 : CP(15,6) ;
      32 : CP(9,6) ;
      33 : CP(6,6) ;
   END ;
END ;



FUNCTION ReturnPlayerNum(Who:STRING) : BYTE ;
VAR
   i,j    : BYTE ;
BEGIN
   FOR i := 1 TO 8 DO BEGIN
      IF GameInfo.PlayerName[i] = Who THEN BEGIN
         IF i = 8 THEN j := 5 ELSE j := i + 8 ;
         ReturnPlayerNum := j ;
         Exit ;
      END ;
   END ;
END ;


PROCEDURE WriteNumbers ;
VAR
   i     : BYTE ;
   Blink : BYTE ;
BEGIN
   FOR i := 1 TO 33 DO BEGIN
      IF ((GameInfo.GameData[i].Owner <> '')
      AND (GameInfo.GameData[i].PurchasePrice > 0)) THEN BEGIN
         PutCursor(i) ;
         IF GameInfo.GameData[i].SellPrice > 0 THEN Blink := 1
           ELSE Blink := 0 ;
         IF Blink > 0 THEN BEGIN
            CursorPos(Y,X-1) ;
            sDisplay(0,14,0,'') ;
         END ;
         sDisplay(0,ReturnPlayerNum(GameInfo.GameData[i].Owner),0,FixByte(i)) ;
      END ELSE IF ((GameInfo.GameData[i].PurchasePrice > 0)
      AND (GameInfo.GameData[i].Owner = '')) THEN BEGIN
         PutCursor(i) ;
         sDisplay(0,7,0,FixByte(i)) ;
      END ;
   END ;
END ;


PROCEDURE DrawBoard ;
BEGIN
   ClearScreen ;
   GameScreen(EABoardName) ;
   WriteNumbers ;
   PutPlayer(PlayerSquareNumber) ;
   CursorPos(1,43) ;
   sDisplay(0,14,0,ItoA(GameNumber)) ;
END ;


PROCEDURE DrawDie(DiceValue : BYTE) ;
VAR
   DiceStr    : ARRAY [1..3] OF STRING[6] ;
   TCol       : BYTE ;
BEGIN
   Tcol := 24 ;
   CASE DiceValue OF
      1 : BEGIN
             DiceStr[1] := '     ' ;
             DiceStr[2] := '    ' ;
             DiceStr[3] := '     ' ;
          END ;
      2 : BEGIN
             DiceStr[1] := '    ' ;
             DiceStr[2] := '     ' ;
             DiceStr[3] := '    ' ;
          END ;
      3 : BEGIN
             DiceStr[1] := '    ' ;
             DiceStr[2] := '    ' ;
             DiceStr[3] := '    ' ;
          END ;
      4 : BEGIN
             DiceStr[1] := '   ' ;
             DiceStr[2] := '     ' ;
             DiceStr[3] := '   ' ;
          END ;
      5 : BEGIN
             DiceStr[1] := '   ' ;
             DiceStr[2] := '    ' ;
             DiceStr[3] := '   ' ;
          END ;
      6 : BEGIN
             DiceStr[1] := '   ' ;
             DiceStr[2] := '   ' ;
             DiceStr[3] := '   ' ;
          END ;
   END ;
   CursorPos(5,TCol) ;
   sDisplay(7,0,0,DiceStr[1]) ;
   CursorPos(6,TCol) ;
   sDisplay(7,0,0,DiceStr[2]) ;
   CursorPos(7,TCol) ;
   sDisplay(7,0,0,DiceStr[3]) ;
   SetColor(0,7,0) ;
   CursorPos(7,29) ;
   sDisplay(0,7,0,' ') ;
END ;


PROCEDURE ClearDie ;
BEGIN
   CursorPos(5,24) ;
   sDisplay(0,15,0,'      ') ;
   CursorPos(6,24) ;
   sDisplay(0,15,0,'      ') ;
   CursorPos(7,24) ;
   sDisplay(0,15,0,'      ') ;
END ;


FUNCTION RollDie : BYTE ;
VAR
   j  : INTEGER ;
   i  : BYTE ;
BEGIN
   ClearDie ;
   FOR i := 1 TO 3 DO BEGIN
      REPEAT
         j := Random(30000) ;
      UNTIL (j > 0) AND (j < 7) ;
      DrawDie(j) ;
      DELAY(200) ;
   END ;
   RollDie := j ;
END ;


PROCEDURE PopulateGlobals ;
BEGIN
   PlayerScore := GameInfo.PlayerScore[PlayerNumber] ;
   SavedScore := PlayerScore ;
   TurnCount := GameInfo.TurnCount[PlayerNumber] ;
   PlayerSquareNumber := GameInfo.PlayerSquareNumber[PlayerNumber] ;
   LastDate := GameInfo.LastDate[PlayerNumber] ;
   OutOfGame := GameInfo.OutOfGame[PlayerNumber] ;
   InJail := GameInfo.InJail[PlayerNumber] ;
   GetOutOfJail := GameInfo.GetOutOfJail[PlayerNumber] ;
   DartScore := GameInfo.DartScore[PlayerNumber] ;
END ;



FUNCTION Block(BlockNumber:BYTE;OwnedBy:STRING) : BOOLEAN ;
VAR
   Tbool : BOOLEAN ;
BEGIN
   Tbool := FALSE ;
   CASE BlockNumber OF
      1 : BEGIN
             IF (GameInfo.GameData[2].Owner = OwnedBy)
             AND (GameInfo.GameData[3].Owner = OwnedBy)
             AND (GameInfo.GameData[4].Owner = OwnedBy) THEN Tbool := TRUE ;
          END ;
      2 : BEGIN
             IF (GameInfo.GameData[6].Owner = OwnedBy)
             AND (GameInfo.GameData[7].Owner = OwnedBy)
             AND (GameInfo.GameData[8].Owner = OwnedBy) THEN Tbool := TRUE ;
          END ;
      3 : BEGIN
             IF (GameInfo.GameData[9].Owner = OwnedBy)
             AND (GameInfo.GameData[10].Owner = OwnedBy)
             AND (GameInfo.GameData[11].Owner = OwnedBy)
             AND (GameInfo.GameData[12].Owner = OwnedBy) THEN Tbool := TRUE ;
          END ;
      4 : BEGIN
             IF (GameInfo.GameData[19].Owner = OwnedBy)
             AND (GameInfo.GameData[20].Owner = OwnedBy)
             AND (GameInfo.GameData[21].Owner = OwnedBy) THEN Tbool := TRUE ;
          END ;
      5 : BEGIN
             IF (GameInfo.GameData[22].Owner = OwnedBy)
             AND (GameInfo.GameData[24].Owner = OwnedBy)
             AND (GameInfo.GameData[25].Owner = OwnedBy) THEN Tbool := TRUE ;
          END ;
      6 : BEGIN
             IF (GameInfo.GameData[26].Owner = OwnedBy)
             AND (GameInfo.GameData[27].Owner = OwnedBy)
             AND (GameInfo.GameData[28].Owner = OwnedBy) THEN Tbool := TRUE ;
          END ;
      7 : BEGIN
             IF (GameInfo.GameData[30].Owner = OwnedBy)
             AND (GameInfo.GameData[32].Owner = OwnedBy)
             AND (GameInfo.GameData[33].Owner = OwnedBy) THEN Tbool := TRUE ;
          END ;
   END ;
   Block := Tbool ;
END ;

FUNCTION GetBlockNumber(Square:BYTE) : BYTE ;
VAR
   t  : BYTE ;
BEGIN
   t := 0 ;
   CASE Square OF
      2,3,4      : t := 1 ;
      6,7,8      : t := 2 ;
      9,10,11,12 : t := 3 ;
      19,20,21   : t := 4 ;
      22,24,25   : t := 5 ;
      26,27,28   : t := 6 ;
      30,32,33   : t := 7 ;
   END ;
   GetBlockNumber := t ;
END ;


PROCEDURE WriteBar(StrIn:STRING) ;
VAR
   Tstr : STRING ;
BEGIN
   Tstr := '' ;
   Tstr := Center(StrIn,79) ;
   sDisplay(7,0,0,Tstr+MkString(79-Length(Tstr),#32)) ;
   sDisplay(0,15,0,' ') ;
END ;


PROCEDURE UpdateMarket ;
VAR
   i     : BYTE ;
   Color : BYTE ;
   ts    : STRING ;
BEGIN
   FOR i := 1 TO 33 DO BEGIN
      ts := ' ' ;
      IF (GameInfo.GameData[i].Owner <> '')
      AND (GameInfo.GameData[i].SellPrice > 0) THEN BEGIN
         ts := '' ;
      END ;
      IF (GameInfo.GameData[i].Owner <> '')
      AND (GameInfo.GameData[i].PurchasePrice > 0) THEN BEGIN
         Color := ReturnPlayerNum(GameInfo.GameData[i].Owner) ;
      END ELSE Color := 7 ;
      CASE i OF
         2  : BEGIN
                 CursorPos(8,10) ;
                 sDisplay(0,Color,0,'FARM') ;
                 sDisplay(0,14,0,ts) ;
              END ;
         3  : BEGIN
                 CursorPos(8,29) ;
                 sDisplay(0,Color,0,'SALON') ;
                 sDisplay(0,14,0,ts) ;
              END ;
         4  : BEGIN
                 CursorPos(8,48) ;
                 sDisplay(0,Color,0,'HOTEL') ;
                 sDisplay(0,14,0,ts) ;
              END ;
         6  : BEGIN
                 CursorPos(8,67) ;
                 sDisplay(0,Color,0,'CLUB') ;
                 sDisplay(0,14,0,ts) ;
              END ;
         7  : BEGIN
                 CursorPos(10,10) ;
                 sDisplay(0,Color,0,'MOVIE') ;
                 sDisplay(0,14,0,ts) ;
              END ;
         8  : BEGIN
                 CursorPos(10,29) ;
                 sDisplay(0,Color,0,'STORE') ;
                 sDisplay(0,14,0,ts) ;
              END ;
         9  : BEGIN
                 CursorPos(10,48) ;
                 sDisplay(0,Color,0,'FOOD') ;
                 sDisplay(0,14,0,ts) ;
              END ;
         10 : BEGIN
                 CursorPos(10,67) ;
                 sDisplay(0,Color,0,'CONDO') ;
                 sDisplay(0,14,0,ts) ;
              END ;
         11 : BEGIN
                 CursorPos(12,10) ;
                 sDisplay(0,Color,0,'GOLF' ) ;
                 sDisplay(0,14,0,ts) ;
              END ;
         12 : BEGIN
                 CursorPos(12,29) ;
                 sDisplay(0,Color,0,'TENNIS' ) ;
                 sDisplay(0,14,0,ts) ;
              END ;
         19 : BEGIN
                 CursorPos(12,48) ;
                 sDisplay(0,Color,0,'VIDEOS' ) ;
                 sDisplay(0,14,0,ts) ;
              END ;
         20 : BEGIN
                 CursorPos(12,67) ;
                 sDisplay(0,Color,0,'BANK' ) ;
                 sDisplay(0,14,0,ts) ;
              END ;
         21 : BEGIN
                 CursorPos(14,10) ;
                 sDisplay(0,Color,0,'LIQUOR' ) ;
                 sDisplay(0,14,0,ts) ;
              END ;
         22 : BEGIN
                 CursorPos(14,29) ;
                 sDisplay(0,Color,0,'CASINO' ) ;
                 sDisplay(0,14,0,ts) ;
              END ;
         24 : BEGIN
                 CursorPos(14,48) ;
                 sDisplay(0,Color,0,'MASSAGE' ) ;
                 sDisplay(0,14,0,ts) ;
              END ;
         25 : BEGIN
                 CursorPos(14,67) ;
                 sDisplay(0,Color,0,'BAND' ) ;
                 sDisplay(0,14,0,ts) ;
              END ;
         26 : BEGIN
                 CursorPos(16,10) ;
                 sDisplay(0,Color,0,'AL''S' ) ;
                 sDisplay(0,14,0,ts) ;
              END ;
         27 : BEGIN
                 CursorPos(16,29) ;
                 sDisplay(0,Color,0,'THEATRE' ) ;
                 sDisplay(0,14,0,ts) ;
              END ;
         28 : BEGIN
                 CursorPos(16,48) ;
                 sDisplay(0,Color,0,'CARS' ) ;
                 sDisplay(0,14,0,ts) ;
              END ;
         30 : BEGIN
                 CursorPos(16,67) ;
                 sDisplay(0,Color,0,'SUITS' ) ;
                 sDisplay(0,14,0,ts) ;
              END ;
         32 : BEGIN
                 CursorPos(18,10) ;
                 sDisplay(0,Color,0,'SPA' ) ;
                 sDisplay(0,14,0,ts) ;
              END ;
         33 : BEGIN
                 CursorPos(18,29) ;
                 sDisplay(0,Color,0,'BOOKS' ) ;
                 sDisplay(0,14,0,ts) ;
              END ;
      END ;
   END ;
END ;



PROCEDURE Market ;
VAR
   yn,
   ch         : CHAR ;
   tstr       : STRING ;
   howmuch,
   tval       : INTEGER ;
BEGIN
   ClearScreen ;
   GameScreen('ANSFILES\ESTATE.ANS') ;
   UpdateMarket ;
   REPEAT
      ResetButtons ;
      AddButton('B') ;
      AddButton('S') ;
      AddButton('R') ;
      AddButton('Q') ;
      SendButtons(#13) ;
      buttonchange := true ;
      ClearStatusArea ;
      CursorPos(20,1) ;
      WriteBar('   Cash: $'+Itoa(PlayerScore)) ;
      CursorPos(22,1) ;
      sDisplay(0,15,0,'<B>uy Property, <S>ell Property, <R>emove From Market, or <Q>uit: ') ;
      REPEAT
         ch := UPCASE(GetChar) ;
      UNTIL ch IN ['B','S','R','Q'] ;
      sDisplay(0,14,0,ch) ;
      CASE ch OF
         'B' : BEGIN
                  TenButtons ;
                  ClearStatusArea ;
                  CursorPos(20,1) ;
                  sDisplay(0,13,0,'Enter property number to buy: ') ;
                  tstr := GetInput('',1,2) ;
                  tval := AtoI(tstr) ;
                  IF (tstr = '') OR (tval < 1) THEN BEGIN
                     CursorPos(22,1) ;
                     sDisplay(0,12,0,'Invalid entry!') ;
                     DELAY(1500) ;
                  END ELSE BEGIN
                     ClearStatusArea ;
                     CASE tval OF
                        2,3,4,6,7,8,9,10,
                        11,12,19,20,21,22,
                        24,25,26,27,28,30,
                        32,33 : BEGIN
                                   IF GameInfo.GameData[tval].Owner = Alias THEN
                                      WriteDisplay(12,'You already own that property!')
                                   ELSE IF GameInfo.GameData[tval].SellPrice < 1 THEN
                                      WriteDisplay(12,'That property is not for sale!')
                                   ELSE BEGIN
                                      CursorPos(20,1) ;
                                      sDisplay(0,10,0,'This property is owned and for sale by: ') ;
                                      sDisplay(0,15,0,GameInfo.GameData[tval].Owner) ;
                                      sDisplay(0,10,0,' for $'+ItoA(GameInfo.GameData[tval].SellPrice)) ;
                                      CursorPos(21,1) ;
                                      sDisplay(0,14,0,'Normal purchase price: $'+
                                                      ItoA(GameInfo.GameData[tval].PurchasePrice)+
                                                      '  Rental price: $'+
                                                      ItoA(GameInfo.GameData[tval].RentalPrice)) ;
                                      IF PlayerScore < GameInfo.GameData[tval].SellPrice THEN BEGIN
                                         CursorPos(22,1) ;
                                         sDisplay(0,12,0,'You do not have enough money to buy this property.') ;
                                         Pause ;
                                      END ELSE BEGIN
                                         YesNo ;
                                         CursorPos(22,1) ;
                                         sDisplay(0,14,0,'Purchase property? [y,n]: ') ;
                                         REPEAT
                                            yn := UPCASE(GetChar) ;
                                         UNTIL yn IN ['Y','N'] ;
                                         sDisplay(0,15,0,yn) ;
                                         IF yn = 'Y' THEN BEGIN
                                            DEC(PlayerScore,GameInfo.GameData[tval].SellPrice) ;
                                            GameInfo.GameData[tval].Owner := Alias ;
                                            GameInfo.GameData[tval].SellPrice := 0 ;
                                            WriteDisplay(10,'Title transferred.') ;
                                            { ReadThisGame(TRUE) ; }
                                            UpdateMarket ;
                                            IF Block(GetBlockNumber(tval),Alias) THEN BEGIN
                                               WriteDisplay(11,'You now own City Block number '+
                                                               ItoA(GetBlockNumber(tval))) ;
                                            END ;
                                         END ELSE WriteDisplay(12,'No transaction has taken place.') ;
                                      END ;
                                   END ;
                                END ;
                        ELSE WriteDisplay(12,'Invalid entry!') ;
                     END ; {case}
                  END ;
               END ;
         'S',
         'R' : BEGIN
                  TenButtons ;
                  ClearStatusArea ;
                  CursorPos(20,1) ;
                  sDisplay(0,13,0,'Enter property number: ') ;
                  tstr := GetInput('',1,2) ;
                  tval := AtoI(tstr) ;
                  IF (tstr = '') OR (tval < 1) THEN BEGIN
                     CursorPos(22,1) ;
                     sDisplay(0,12,0,'Invalid entry!') ;
                     DELAY(1500) ;
                  END ELSE BEGIN
                     ClearStatusArea ;
                     CASE tval OF
                        2,3,4,6,7,8,9,10,
                        11,12,19,20,21,22,
                        24,25,26,27,28,30,
                        32,33 : BEGIN
                                   IF GameInfo.GameData[tval].Owner <> Alias THEN
                                      WriteDisplay(12,'You do not own that property!')
                                   ELSE BEGIN
                                      CursorPos(20,1) ;
                                      sDisplay(0,15,0,'Normal purchase price: $'+
                                                      ItoA(GameInfo.GameData[tval].PurchasePrice)+
                                                      '.  Rental price: $'+
                                                      ItoA(GameInfo.GameData[tval].RentalPrice)) ;
                                      CursorPos(21,1) ;
                                      sDisplay(0,14,0,'Sell for how much? '+
                                                      '[$0..9999]') ;
                                      sDisplay(0,12,0,' (0 = take off market)') ;
                                      sDisplay(0,14,0,': $') ;
                                      tstr := '' ;
                                      tstr := GetInput('',1,4) ;
                                      howmuch := AtoI(tstr) ;
                                      IF howmuch = 0 THEN BEGIN
                                         CursorPos(22,1) ;
                                         sDisplay(0,9,0,'Property is not for sale.') ;
                                         GameInfo.GameData[tval].SellPrice := 0 ;
                                         { ReadThisGame(TRUE) ; }
                                         UpdateMarket ;
                                         Pause ;
                                      END ELSE BEGIN
                                         IF howmuch > 9999 THEN BEGIN
                                            CursorPos(22,1) ;
                                            sDisplay(0,12,0,'That price is too high!') ;
                                            Pause ;
                                         END ELSE BEGIN
                                            CursorPos(22,1) ;
                                            sDisplay(0,9,0,'Property has been placed on the market for $'+
                                                           ItoA(Howmuch)) ;
                                            GameInfo.GameData[tval].SellPrice := Howmuch ;
                                            { ReadThisGame(TRUE) ; }
                                            UpdateMarket ;
                                            Pause ;
                                         END ;
                                      END ;
                                   END ;
                                END ;
                        ELSE WriteDisplay(12,'Invalid entry!') ;
                     END ; {case}
                  END ;
               END ;
      END ; {case}
   UNTIL ch = 'Q' ;
END ;




FUNCTION NumberOfProperties : BYTE ;
VAR
   Tval   : BYTE ;
   i      : BYTE ;
BEGIN
   Tval := 0 ;
   FOR i := 1 TO 33 DO
      IF GameInfo.GameData[i].Owner = Alias THEN INC(Tval) ;
   NumberOfProperties := Tval ;
END ;



PROCEDURE ShowSpace ;
VAR
   yn    : CHAR ;
BEGIN
   ClearStatusArea ;
   CursorPos(20,1) ;
   sDisplay(0,3,0,'Square Number: ') ;
   sDisplay(0,9,0,ItoA(PlayerSquareNumber)) ;
   sDisplay(0,3,0,'    Description: ') ;
   sDisplay(0,9,0,GameInfo.GameData[PlayerSquareNumber].Description) ;
   IF GameInfo.GameData[PlayerSquareNumber].SellPrice > 0 THEN BEGIN
      sDisplay(0,14,0,' (') ;
      sDisplay(0,12,0,'FOR SALE') ;
      sDisplay(0,14,0,')') ;
   END ;
   IF GameInfo.GameData[PlayerSquareNumber].PurchasePrice > 0 THEN BEGIN
      CursorPos(21,1) ;
      sDisplay(0,3,0,'Purchase Price: $') ;
      sDisplay(0,9,0,ItoA(GameInfo.GameData[PlayerSquareNumber].PurchasePrice)) ;
      sDisplay(0,3,0,'   Rental Price: $') ;
      sDisplay(0,9,0,ItoA(GameInfo.GameData[PlayerSquareNumber].RentalPrice)) ;
   END ELSE Pause ;
   IF (GameInfo.GameData[PlayerSquareNumber].Owner <> '')
   AND (GameInfo.GameData[PlayerSquareNumber].PurchasePrice > 0) THEN BEGIN
      CursorPos(22,1) ;
      sDisplay(0,3,0,'This property is owned by: ') ;
      IF GameInfo.GameData[PlayerSquareNumber].Owner = Alias THEN
         sDisplay(0,11,0,'YOU'+#27+'[K')
      ELSE
         sDisplay(0,11,0,GameInfo.GameData[PlayerSquareNumber].Owner+#27+'[K') ;
      Pause ;
   END ELSE BEGIN
      IF (GameInfo.GameData[PlayerSquareNumber].PurchasePrice > 0)
      AND (GameInfo.GameData[PlayerSquareNumber].Owner = '') THEN BEGIN
         IF PlayerScore < GameInfo.GameData[PlayerSquareNumber].PurchasePrice THEN BEGIN
            CursorPos(22,1) ;
            sDisplay(0,12,0,'You do not have enough money to purchase this property.') ;
            Pause ;
         END ELSE BEGIN
            YesNo ;
            CursorPos(22,1) ;
            sDisplay(0,9,0,'This property is for sale.  Do you wish to buy it? [y/n]: ') ;
            REPEAT
               yn := UPCASE(GetChar) ;
            UNTIL yn IN ['Y','N'] ;
            sDisplay(0,15,0,yn) ;
            IF yn = 'Y' THEN BEGIN
               IF PlayerScore < GameInfo.GameData[PlayerSquareNumber].PurchasePrice THEN BEGIN
                  ClearStatusArea ;
                  CursorPos(20,1) ;
                  sDisplay(0,12,0,'You do not have enough money!') ;
                  Pause ;
               END ELSE BEGIN
                  DEC(PlayerScore,GameInfo.GameData[PlayerSquareNumber].PurchasePrice) ;
                  GameInfo.GameData[PlayerSquareNumber].Owner := Alias ;
                  GameInfo.GameData[PlayerSquareNumber].SellPrice := 0 ;
                  { ReadThisGame(TRUE) ; }
                  ClearStatusArea ;
                  CursorPos(20,1) ;
                  sDisplay(0,11,0,'You are now the proud owner of '+
                                  GameInfo.GameData[PlayerSquareNumber].Description) ;
                  IF Block(GetBlockNumber(PlayerSquareNumber),Alias) THEN BEGIN
                     CursorPos(21,1) ;
                     sDisplay(0,10,0,'You now own City Block number: '+
                                     ItoA(GetBlockNumber(PlayerSquareNumber))+
                                     '  Rents are doubled.') ;
                  END ;
                  WriteNumbers ;
                  Pause ;
               END ;
            END ELSE WriteDisplay(12,'No purchase was made') ;
         END ;
      END ;
   END ;
   ClearStatusArea ;
END ;


FUNCTION TaxAmount(n : INTEGER) : INTEGER ;
VAR
   Tval   : INTEGER ;
BEGIN
   Tval := TRUNC((n * 0.1)) ;
   TaxAmount := Tval ;
END ;


PROCEDURE GameOver(n:INTEGER;Dead:BOOLEAN) ;
VAR
   i         : BYTE ;
   Tval      : INTEGER ;
   BillsPaid : BOOLEAN ;
BEGIN
   BillsPaid := FALSE ;
   WriteDisplay(11,'Cashing out your properties...') ;
   FOR i := 1 TO 33 DO BEGIN
      IF GameInfo.GameData[i].Owner = Alias THEN BEGIN
         GameInfo.GameData[i].Owner := '' ;
         GameInfo.GameData[i].SellPrice := 0 ;
         Tval := GameInfo.GameData[i].PurchasePrice ;
         IF NOT Dead THEN INC(PlayerScore,Tval) ;
         WriteDisplay(12,'Cashed out property: '+
                         GameInfo.GameData[i].Description+
                         ' at $'+ItoA(Tval)) ;
         IF PlayerScore >= n THEN BEGIN
            WriteDisplay(12,'Subtracting $'+ItoA(n)+
                            ' to pay your bills!') ;
            DEC(PlayerScore,n) ;
            BillsPaid := TRUE ;
            i := 33 ;
         END ELSE WriteDisplay(12,'You still don''t have enough to pay your bills!') ;
      END ;
   END ;
   TurnCount := Info.TurnsPerGame ;
   IF NOT BillsPaid THEN PlayerScore := 0 ;
   IF PlayerScore < 1 THEN BEGIN
      WriteDisplay(12,'You have nothing of value left!  You are OUT of this game!') ;
      OutOfGame := TRUE ;
   END ELSE WriteDisplay(12,'Your turn is over for today but you''re still in the game!') ;
   { ReadThisGame(True) ; }
   PostScores(False) ;
   WriteNumbers ;
END ;



PROCEDURE GoToStart ;
BEGIN
   REPEAT
      INC(PlayerSquareNumber) ;
      IF PlayerSquareNumber > 33 THEN PlayerSquareNumber := 1 ;
      PutPlayer(PlayerSquareNumber) ;
      DELAY(100) ;
   UNTIL PlayerSquareNumber = 1 ;
   WriteDisplay(11,'You receive $1500 for landing directly on START!') ;
   INC(PlayerScore,1500) ;
END ;

PROCEDURE GoToSpace(i:BYTE) ;
BEGIN
   REPEAT
      INC(PlayerSquareNumber) ;
      IF PlayerSquareNumber > 33 THEN PlayerSquareNumber := 1 ;
      PutPlayer(PlayerSquareNumber) ;
      DELAY(100) ;
   UNTIL PlayerSquareNumber = i ;
END ;


PROCEDURE GoToJail ;
BEGIN
   REPEAT
      INC(PlayerSquareNumber) ;
      IF PlayerSquareNumber > 33 THEN PlayerSquareNumber := 1 ;
      PutPlayer(PlayerSquareNumber) ;
      DELAY(100) ;
   UNTIL PlayerSquareNumber = 13 ;
   InJail := TRUE ;
   WriteMsg(12,'You''re in jail!') ;
   IF GetOutOfJail THEN BEGIN
      WriteDisplay(11,'You use your FREE BAIL BOND CARD and are just visiting.') ;
      InJail := FALSE ;
      GetOutOfJail := FALSE ;
   END ;
END ;


PROCEDURE RobBank ;
VAR
   AreYouSure    : CHAR ;
   j,jj          : INTEGER ;
BEGIN
   YesNo ;
   ClearStatusArea ;
   if gameinfo.gamedata[20].owner = alias then begin
      cursorpos(20,1) ;
      sdisplay(0,11,0,'Since you own the bank, your employees would recognize you and you') ;
      cursorpos(21,1) ;
      sdisplay(0,11,0,'would be busted for sure, so you decide not to pull such a stunt!') ;
      pause ;
      RobIsOn := false ;
      exit ;
   end ;
   CursorPos(20,1) ;
   sDisplay(0,11,0,'Fact:  Two out of three bank robbers are never caught.') ;
   CursorPos(22,1) ;
   sDisplay(0,14,0,'Are you sure you want to rob the bank? [y,n]: ') ;
   REPEAT
      AreYouSure := UPCASE(GetChar) ;
   UNTIL AreYouSure IN ['Y','N'] ;
   sDisplay(0,15,0,AreYouSure) ;
   IF AreYouSure = 'N' THEN BEGIN
      WriteDisplay(11,'After reconsidering you decide to sneak out un-noticed.') ;
      Exit ;
   END ;
   RobIsOn := FALSE ;
   ClearStatusArea ;
   CursorPos(20,1) ;
   sDisplay(0,7,0,'After handing the teller a note, she nervously packs a wad of cash into a') ;
   CursorPos(21,1) ;
   sDisplay(0,7,0,'sack, as instructed.  Trembling, she hands you the hastily-stuffed bag.') ;
   CursorPos(22,1) ;
   sDisplay(0,7,0,'Turning around, you begin walking briskly towards the door...') ;
   Pause ;
   REPEAT
      j := Random(101) ;
   UNTIL (j > 0) AND (j < 4) ;
   IF (j = 1) OR (j = 3) THEN BEGIN
      REPEAT
         jj := Random(10000) ;
      UNTIL (jj > 999) AND (jj < 5001) ;
      WriteDisplay(10,'Looks like you''re one of the lucky ones.  You got away with $'+ItoA(jj)+'!') ;
      INC(PlayerScore,jj) ;
   END ELSE BEGIN
      PlayerScore := 100 ;
      WriteDisplay(12,'BUSTED!  You forfeit all but $100 of your cash on-hand.  Go to jail!') ;
      GotoJail ;
   END ;
   PostScores(False) ;
END ;


{$I CHANCE.PAS}


PROCEDURE PayOrPlay ;
VAR
   ch      : CHAR ;
   OwnedBy : STRING[35] ;
   Rent    : INTEGER ;
   j       : byte ;
BEGIN
   ClearStatusArea ;
   OwnedBy := GameInfo.GameData[PlayerSquareNumber].Owner ;
   Rent := GameInfo.GameData[PlayerSquareNumber].RentalPrice ;
   IF Block(GetBlockNumber(PlayerSquareNumber),OwnedBy) THEN BEGIN
      Rent := Rent * 2 ;
      Say(1,'This BLOCK is owned by '+OwnedBy+'.  The rent is: $'+ItoA(Rent)) ;
   END ELSE Say(1,'This property is owned by '+OwnedBy+'.  The rent is: $'+ItoA(Rent)) ;
   IF PlayerScore < Rent THEN BEGIN
      Say(2,'You don''t have enough to pay the rent!') ;
      Pause ;
      GameOver(Rent,False) ;
      Exit ;
   END ELSE BEGIN
      DEC(PlayerScore,Rent) ;
      for j := 1 to 8 do
      begin
         if gameinfo.playername[j] = OwnedBy then
         begin
            inc(gameinfo.playerscore[j],Rent) ;
            j := 8 ;
         end ;
      end ;
      ReadThisGame(True) ;
      PostScores(True) ;
      Pause ;
   END ;
END ;


FUNCTION GetNumberOfGames:BYTE ;
VAR
   tval    : BYTE ;
BEGIN
   tval := 0 ;
   fn := 'EA.GAM' ;
   ASSIGN(GameFile,fn) ;
   RESET(GameFile) ;
   IF FileSize(GameFile) > 0 THEN tval := FileSize(GameFile) ;
   CLOSE(GameFile) ;
   GetNumberOfGames := tval ;
END ;


PROCEDURE PropertySummary(n:BYTE) ;
VAR
   jj,
   j,
   i  : BYTE ;
BEGIN
   ClearScreen ;
   Display(0,14,0,Center('Property Availability Summary For Game #'+ItoA(n),79)) ;
   Crlf ;         {123456789012345678901234567890123456789012345678901234567890123456789012345678}
   Display(0,13,0,'Property Description & Number   Block   Property Status') ;
   Display(0,15,0,'      ') ;
   j := 0 ;
   FOR i := 1 TO 33 DO BEGIN
      IF GameInfo.GameData[i].PurchasePrice > 0 THEN BEGIN
         sDisplay(0,GetBlockNumber(i),0,
                  LJust(GameInfo.GameData[i].Description+' ['+
                  ItoA(i)+']',29)) ;
         sDisplay(0,15,0,'   ') ;
         sDisplay(0,GetBlockNumber(i),0,LJust('*'+ItoA(GetBlockNumber(i))+'*',5)) ;
         sDisplay(0,12,0,'   ') ;
         IF GameInfo.GameData[i].Owner <> '' THEN
           Display(0,GetBlockNumber(i),0,'Owned by: '+COPY(GameInfo.GameData[i].Owner,1,28))
         ELSE
           Display(0,(GetBlockNumber(i)+8),0,'Available Property') ;
         INC(j) ;
         CASE i OF
           4,8,12,21,25,28 : BEGIN
                                Crlf ;
                                INC(j) ;
                             END ;
         END ;
         IF j MOD 17 = 0 THEN BEGIN
            More('More to come - press <any key>',12) ;
            FOR jj := 5 TO 23 DO BEGIN
               CursorPos(jj,1) ;
               sDisplay(0,15,0,#27+'[K') ;
            END ;
            CursorPos(5,1) ;
         END ;
      END ;
   END ;
   Crlf ;
   More('Press <any key> to continue',14) ;
END ;

FUNCTION DaysLeft : BYTE ;
VAR
   today       : REAL ;
   age         : INTEGER ;
BEGIN
   GetDate(yr,mn,dt,dy) ;
   Today := Julian(yr,mn,dt) ;
   Age := TRUNC((Today - GameInfo.StartDate)) ;
   IF Age > Info.GameRetention THEN Age := Info.GameRetention ;
   DaysLeft := Info.GameRetention - Age ;
END ;


PROCEDURE ShowBoard(n:BYTE) ;
VAR
   j,i         : BYTE ;
   tval        : INTEGER ;
   Players     : BYTE ;
   tcount      : BYTE ;
   ch          : CHAR ;
   ts          : STRING[5] ;
BEGIN
   fn := 'EA.GAM' ;
   ASSIGN(GameFile,fn) ;
   RESET(GameFile) ;
   SEEK(GameFile,n-1) ;
   READGame ;
   CLOSE(GameFile) ;
   Crlf ;
   sDisplay(0,14,0,'GAME: ') ;
   sDisplay(0,15,0,'#'+ItoA(n)) ;
   sDisplay(0,14,0,MkString(50,#32)+'EXPIRES IN ') ;
   sDisplay(0,15,0,ItoA(DaysLeft)) ;
   Display(0,14,0,' DAYS') ;
   Display(0,15,0,'') ;
   Players := 0 ;
   FOR j := 1 TO 8 DO BEGIN
      IF GameInfo.PlayerName[j] <> '' THEN BEGIN
         INC(Players) ;
         sDisplay(0,12,0,GameInfo.PlayerName[j]) ;
         sDisplay(0,3,0,' Owns ') ;
         tval := 0 ;
         tcount := 0 ;
         FOR i := 1 TO 33 DO BEGIN
            IF GameInfo.GameData[i].Owner = GameInfo.PlayerName[j] THEN BEGIN
               INC(tval,GameInfo.GameData[i].PurchasePrice) ;
               INC(tcount) ;
            END ;
         END ;
         sDisplay(0,12,0,ItoA(tcount)) ;
         sDisplay(0,3,0,' properties valued at ') ;
         sDisplay(0,12,0,'$'+ItoA(tval)) ;
         sDisplay(0,3,0,' for a score of ') ;
         Display(0,12,0,'$'+ItoA(tval+GameInfo.PlayerScore[j])) ;
      END ;
   END ;
   Crlf ;
   sDisplay(0,15,0,'Total number of players: ') ;
   Display(0,11,0,ItoA(Players)) ;
   Crlf ;
   sDisplay(0,10,0,'View Player Details For This Game? [y,N]: ') ;
   YesNo ;
   REPEAT
      ch := UPCASE(GetChar) ;
      IF ch = #13 THEN ch := 'N' ;
   UNTIL ch IN ['Y','N'] ;
   Display(0,15,0,ch) ;
   Crlf ;
   IF ch = 'Y' THEN BEGIN
      sDisplay(0,14,0,'Player Details For Game: ') ;
      Display(0,15,0,'#'+ItoA(n)) ;
      Crlf ;
      FOR j := 1 TO 8 DO BEGIN
         IF GameInfo.PlayerName[j] <> '' THEN BEGIN
            display(0,15,0,'===================================================') ;
            sDisplay(0,7,0,'Player:          ') ;
            Display(0,15,0,GameInfo.PlayerName[j]) ;
            sDisplay(0,7,0,'Cash On Hand:    ') ;
            Display(0,15,0,'$'+ItoA(GameInfo.PlayerScore[j])) ;
            sDisplay(0,7,0,'Bar Darts Score: ') ;
            Display(0,15,0,ItoA(GameInfo.DartScore[j])+' points') ;
            sDisplay(0,7,0,'Last Played:     ') ;
            Display(0,15,0,GameInfo.LastDate[j]) ;
            sDisplay(0,7,0,'Status:          ') ;
            IF GameInfo.OutOfGame[j] THEN Display(0,15,0,'OUT OF GAME')
               ELSE Display(0,15,0,'ACTIVE') ;
            Crlf ;
            Display(0,13,0,'Properties Owned:') ;
            Crlf ;
            Tval := 0 ;
            FOR i := 1 TO 33 DO BEGIN
               IF GameInfo.GameData[i].Owner = GameInfo.PlayerName[j] THEN BEGIN
                  INC(Tval) ;

                  IF Block(GetBlockNumber(i),GameInfo.PlayerName[j])
                    THEN ts := '*B'+ItoA(GetBlockNumber(i))+'* ' ELSE ts := '' ;

                  sDisplay(0,11,0,ts+GameInfo.GameData[i].Description) ;
                  sDisplay(0,3,0,' valued at ') ;
                  Display(0,11,0,'$'+ItoA(GameInfo.GameData[i].PurchasePrice)) ;
               END ;
            END ;
            IF Tval = 0 THEN Display(0,11,0,'NONE') ;
            Crlf ;
            More('Press <any key> for next player',12) ;
         END ;
      END ;
   END ;
   sDisplay(0,10,0,'Review Property Availability Summary For This Game? [y,N]: ') ;
   REPEAT
      ch := UPCASE(GetChar) ;
      IF ch = #13 THEN ch := 'N' ;
   UNTIL ch IN ['Y','N'] ;
   Display(0,14,0,ch) ;
   IF ch = 'Y' THEN PropertySummary(n) ;
   Crlf ;
END ;



FUNCTION BuildLine(recno:INTEGER) : STRING ;
VAR
   tstr     : STRING ;
   k        : BYTE ;
   totscore : LONGINT ;
BEGIN
   tstr := '' ;
   tstr := ' ' + ljust(itoa(recno),9) +
           ljust(pastgame.closingdate,13) +
           ljust(itoa(pastgame.numplayers),10) +
           ljust(pastgame.winner,28) ;
   totscore := 0 ;
   for k := 1 to pastgame.numplayers do begin
      if pastgame.playernames[k] = pastgame.winner then begin
         totscore := pastgame.cashscores[k] + pastgame.propertyscores[k] ;
         k := pastgame.numplayers ;
      end ;
   end ;
   tstr := tstr + rjust('$'+commastr(totscore),13) + '    ' ;
   buildline := tstr ;
END ;



FUNCTION PickList : INTEGER ;
CONST
   pagelength = 18 ;
VAR
   v,u                : INTEGER ;
   totallines         : INTEGER ;
   globalposition,
   positioncounter,
   screencounter      : INTEGER ;
   tstr               : ARRAY [1..pagelength] OF STRING[80] ;
   listposition       : INTEGER ;
   ch                 : CHAR ;
BEGIN
   SetRIPDefault ;
   for u := 1 to pagelength do tstr[u] := '' ;
   assign(pastgamefile,'eapast.dat') ;
   reset(pastgamefile) ;
   totallines := filesize(pastgamefile) ;

   { build first screen page }
   screencounter := 0 ;
   positioncounter := 0 ;
   if lastlistpos <> 0 then begin
      positioncounter := lastlistpos - 1 ;
      seek(pastgamefile,lastlistpos - 1) ;
   end ;
   for v := 1 to pagelength do begin
      if positioncounter < totallines then begin
         readpastgame ;
         inc(positioncounter) ;   { how many lines into the data file }
         inc(screencounter) ;     { how many lines are on the screen  }
         tstr[v] := buildline(filepos(pastgamefile)) ;
      end else v := pagelength ;
   end ;
   listposition := 1 ;            { what point on current screen      }
   globalposition := 1 ;          { what point in the data file       }
   if lastlistpos <> 0 then globalposition := lastlistpos ;
   clearscreen ;
{                            1         2         3         4         5         6         7         8
                    12345678901234567890123456789012345678901234567890123456789012345678901234567890 }
   sdisplay(0,15,0,' ') ;
   sdisplay(4,15,0,'Record                 Number                                                 ') ;
   display(0,15,0,'') ;
   sdisplay(0,15,0,' ') ;
   sdisplay(4,15,0,'Number  Closing Date   Players   Game Winner                 Winning Score    ') ;
   display(0,15,0,'') ;
   display(0,15,0,' ') ;
   cursorpos(23,1) ;
   sdisplay(0,14,0,center('(NUM LOCK) 8=UP, 2=DOWN  ENTER=SELECT LINE  SPACEBAR=CONTINUE  ESC,Q=QUIT',79)) ;
   for v := 1 to screencounter do begin
      cursorpos(v+3,2) ;
      sdisplay(0,7,0,tstr[v]) ;
   end ;
   cursorpos(4,2) ;
   sdisplay(7,0,0,tstr[listposition]) ;
   sdisplay(0,15,0,'') ;

   repeat   { menu loop }
      repeat
         ch := upcase(getchar) ;
      until ch in [#27,'Q',#32,#13,'8','2','3'] ;
      case ch of
         #27,'Q' : begin
                      close(pastgamefile) ;
                      picklist := -1 ;
                      exit ;
                   end ;
         #13     : begin
                      { return file position to seek and exit }
                      close(pastgamefile) ;
                      lastlistpos := globalposition ;
                      picklist := globalposition - 1 ;
                      exit ;
                   end ;
         '3',
         #32     : begin
                      { populate the next screen and continue on }
                      for v := 1 to pagelength do tstr[v] := '' ;
                      screencounter := 0 ;
                      if positioncounter >= totallines then begin
                         close(pastgamefile) ;
                         picklist := -1 ;
                         exit ;
                      end ;
                      if positioncounter < totallines then
                         globalposition := positioncounter + 1 ;
                      for v := 1 to pagelength do begin
                         if positioncounter < totallines then begin
                            readpastgame ;
                            inc(positioncounter) ;
                            inc(screencounter) ;
                            tstr[v] := buildline(filepos(pastgamefile)) ;
                         end else v := pagelength ;
                      end ;
                      for u := 4 to 22 do begin
                         cursorpos(u,1) ;
                         sDisplay(0,15,0,#27+'[K') ;
                      end ;
                      for u := 1 to screencounter do begin
                         cursorpos(u+3,2) ;
                         sdisplay(0,7,0,tstr[u]) ;
                      end ;
                      cursorpos(4,2) ;
                      listposition := 1 ;
                      sdisplay(7,0,0,tstr[listposition]) ;
                      sdisplay(0,15,0,'') ;
                   end ;
         '8'     : begin
                      { move up a notch if possible }
                      if listposition > 1 then begin
                         cursorpos(listposition+3,2) ;
                         sdisplay(0,7,0,tstr[listposition]) ;
                         dec(listposition) ;
                         dec(globalposition) ;
                         cursorpos(listposition+3,2) ;
                         sdisplay(7,0,0,tstr[listposition]) ;
                         sdisplay(0,15,0,'') ;
                      end ;
                   end ;
         '2'     : begin
                      { move down a notch if possible }
                      if listposition < screencounter then begin
                         cursorpos(listposition+3,2) ;
                         sdisplay(0,7,0,tstr[listposition]) ;
                         inc(listposition) ;
                         inc(globalposition) ;
                         cursorpos(listposition+3,2) ;
                         sdisplay(7,0,0,tstr[listposition]) ;
                         sdisplay(0,15,0,'') ;
                      end ;
                   end ;
      end ;
   until ch in [#27,'Q'] ;
   close(pastgamefile) ;
END ;



PROCEDURE ShowPastGames ;
VAR
   yn         : CHAR ;
   j          : BYTE ;
   n          : INTEGER ;

   procedure clearfields ;
   var
      v : byte ;
   begin
      cursorpos(3,20) ;
      sdisplay(0,15,0,MkString(4,#32)) ;
      cursorpos(3,42) ;
      sdisplay(0,15,0,MkString(8,#32)) ;
      cursorpos(3,71) ;
      sdisplay(0,15,0,' ') ;
      cursorpos(5,13) ;
      sdisplay(0,15,0,MkString(35,#32)) ;
      cursorpos(5,13) ;
      sdisplay(0,15,0,MkString(35,#32)) ;
      for v := 1 to 8 do begin
         cursorpos(v+10,10) ;
         sdisplay(0,15,0,MkString(67,#32)) ;
      end ;
   end ;

BEGIN
   crlf ;
   if not exist('EAPAST.DAT') then begin
      display(0,12,0,'No past history data was found.') ;
      crlf ;
      More('Press any key:',10) ;
      exit ;
   end ;

   lastlistpos := 0 ;
   repeat
      n := picklist ;
      if n <> -1 then begin
         assign(pastgamefile,'eapast.dat') ;
         reset(pastgamefile) ;
         seek(pastgamefile,n) ;
         readpastgame ;
         close(pastgamefile) ;
         clearscreen ;
         gamescreen('ansfiles\pastgame.ans') ;
         with pastgame do begin
            cursorpos(3,20) ;
            sdisplay(0,14,0,itoa(n+1)) ;
            cursorpos(3,42) ;
            sdisplay(0,14,0,closingdate) ;
            cursorpos(3,71) ;
            sdisplay(0,14,0,itoa(numplayers)) ;
            cursorpos(5,13) ;
            sdisplay(0,10,0,pastgame.winner) ;
            for j := 1 to numplayers do begin
               if playernames[j] <> '' then begin
                  cursorpos(10+j,10) ;
                  sdisplay(0,11,0,copy(playernames[j],1,25)) ;
                  cursorpos(10+j,37) ;
                  sdisplay(0,9,0,rjust('$'+commastr(cashscores[j]),10)) ;
                  cursorpos(10+j,49) ;
                  sdisplay(0,13,0,rjust('$'+commastr(propertyscores[j]),14)) ;
                  cursorpos(10+j,65) ;
                  sdisplay(0,14,0,rjust('$'+commastr(propertyscores[j]+cashscores[j]),11)) ;
               end ;
            end ;
         end ;
         cursorpos(21,1) ;
         sdisplay(0,14,0,center('Press ENTER to continue',79)) ;
         repeat
            yn := getchar ;
         until yn = #13 ;
      end ;
   until n = -1 ;
END ;



PROCEDURE ShowBoardAgent ;
VAR
   yn,
   ch            : CHAR ;
   tstr          : STRING ;
   tval          : INTEGER ;
   NumberOfGames : BYTE ;
   j             : BYTE ;
BEGIN
   NumberOfGames := GetNumberOfGames ;
   Crlf ;
   Display(0,14,0,'There are a total of '+ItoA(NumberOfGames)+' games in progress.') ;
   TenButtons ;
   Crlf ;
   sDisplay(0,11,0,'Enter game number to view or <ENTER> for ALL games: ') ;
   tstr := GetInput('',1,3) ;
   IF tstr <> '' THEN tval := AtoI(tstr) ;
   IF tstr = '' THEN BEGIN
      FOR j := 1 TO NumberOfGames DO BEGIN
         ClearScreen ;
         YesNo ;
         ShowBoard(j) ;
         sDisplay(0,11,0,'View Next Game? [Y,n]') ;
         REPEAT
            yn := UPCASE(GetChar) ;
            IF yn = #13 THEN yn := 'Y' ;
         UNTIL yn IN ['Y','N'] ;
         Display(0,15,0,yn) ;
         IF yn = 'N' THEN Exit ;
      END ;
   END ELSE BEGIN
      IF tval = 0 THEN Exit ;
      IF tval > NumberOfGames THEN BEGIN
         Crlf ;
         Display(0,11,0,'Invalid Entry!') ;
         Exit ;
      END ;
      ShowBoard(tval) ;
   END ;
   More('End of file.  Press <any key> to continue',13) ;
END ;





PROCEDURE ShowPropertiesHeld ;
VAR
   PropertyTotal : LONGINT ;
   FoundOne      : BOOLEAN ;
   Tfile         : TEXT ;
   j             : BYTE ;
   tns           : STRING[12] ;
BEGIN
   GetTime(hr,mn,sec,sec100) ;
   tns:= FixByte(hr)+FixByte(mn)+FixByte(sec)+'.$$$' ;
   fn := tns ;
   ASSIGN(Tfile,tns) ;
   REWRITE(Tfile) ;
   WRITELN(Tfile,' YOUR PROPERTIES:') ;
   WRITELN(Tfile) ;
   FoundOne := FALSE ;
   PropertyTotal := 0 ;
   FOR j := 1 TO 33 DO BEGIN
      IF GameInfo.GameData[j].Owner = Alias THEN BEGIN
         FoundOne := TRUE ;
         IF Block(GetBlockNumber(j),Alias) THEN BEGIN
           INC(PropertyTotal,GameInfo.Gamedata[j].PurchasePrice) ;
           WRITELN(Tfile,' *B'+ItoA(GetBlockNumber(j))+'* '+
                         GameInfo.GameData[j].Description+' ['+FixByte(j)+
                         ']'+'  Value: $'+
                         ItoA(GameInfo.GameData[j].PurchasePrice)+
                         '  Rent: $'+ItoA((GameInfo.GameData[j].RentalPrice*2))) ;
         END ELSE BEGIN
           INC(PropertyTotal,GameInfo.Gamedata[j].PurchasePrice) ;
           WRITELN(Tfile,' '+GameInfo.GameData[j].Description+' ['+
                         FixByte(j)+']'+
                         '  Value: $'+ItoA(GameInfo.GameData[j].PurchasePrice)+
                         '  Rent: $'+ItoA(GameInfo.GameData[j].RentalPrice)) ;
         END ;
      END ;
   END ;
   IF NOT FoundOne THEN WRITELN(Tfile,' NONE!') ;
   WRITELN(Tfile) ;
   WRITELN(Tfile,' TOTAL PROPERTY VALUE: '+Rjust(CommaStr(PropertyTotal),7)) ;
   WRITELN(Tfile,' TOTAL CASH ON HAND:   '+Rjust(CommaStr(PlayerScore),7)) ;
   WRITELN(Tfile,' TOTAL GAME SCORE:     '+Rjust(CommaStr(PropertyTotal+PlayerScore),7)) ;
   WRITELN(Tfile) ;
   IF GetOutOfJail THEN WRITELN(Tfile,' YOU HAVE A FREE BAIL BOND CARD') ;
   FLUSH(Tfile) ;
   CLOSE(Tfile) ;
   WriteToInnerBoard(tns,TRUE,2,TRUE) ;
   RedisplayInnerBoard ;
   PostScores(True) ;
   DeleteFile(tns) ;
END ;



PROCEDURE EvaluateSquare(n:BYTE) ;
VAR
   Deduct   : INTEGER ;
   fall     : BYTE ;
   i        : INTEGER ;
   ch       : CHAR ;
BEGIN
   CASE n OF
      1  : BEGIN
              {start space}
              WriteDisplay(11,'You receive a $1000 bonus for landing directly on START!') ;
              INC(PlayerScore,1000) ;
           END ;
      5,
      16,
      23,
      31 : BEGIN
              { LUCK spaces }
              ClearStatusArea ;
              WriteDisplay(12,'LUCK!   Get ready to draw!') ;
              ClearStatusArea ;
              REPEAT
                 i := Random(150) ;
              UNTIL (i > 0) AND (i <= MaxChances) ;
              IF (i = 27) or (i = 36) THEN BEGIN
                 i := FreeSquare ;
                 GotoSpace(i) ;
                 IF i = 1 THEN BEGIN
                    ClearStatusArea ;
                    WriteDisplay(10,'You collect $500 for passing start!') ;
                    INC(PlayerScore,500) ;
                    PostScores(True) ;
                 END ;
                 EvaluateSquare(i) ;
              END ELSE IF (i = 32) or (i = 33) THEN BEGIN
                 ClearStatusArea ;
                 Say(1,'Move back TWO SPACES!') ;
                 GotoSpace(PlayerSquareNumber-2) ;
                 EvaluateSquare(PlayerSquareNumber) ;
              END ELSE IF (i = 34) or (i = 35) THEN BEGIN
                 ClearStatusArea ;
                 Say(1,'Go to LOOK OUT POINT') ;
                 GotoSpace(18) ;
                 EvaluateSquare(PlayerSquareNumber) ;
              END ELSE Chance(i) ;
           END ;
      13 : BEGIN
              { in jail - visiting }
              WriteDisplay(11,'You''re in jail!  Good thing you''re just visiting.') ;
           END ;
      14 : BEGIN
              WriteDisplay(10,'GO TO START!') ;
              GotoStart ;
              Exit ;
           END ;
      15 : BEGIN
              { Trivia time! }
              WriteDisplay(10,'Trivia Time!') ;
              PlayTrivia ;
              RedisplayInnerBoard ;
              SavedScore := 0 ;
              DrawFull := TRUE ;
           END ;
      17 : BEGIN
              { pay taxes - 10% of your score }
              Deduct := TaxAmount(PlayerScore) ;
              DEC(PlayerScore,Deduct) ;
              WriteDisplay(12,'Tax Time!  You pay 10% to Uncle Sam ($'+ItoA(Deduct)+').') ;
           END ;

      29 : BEGIN
              { go to jail }
              WriteDisplay(12,'GO TO JAIL!') ;
              GotoJail ;
              Exit ;
           END ;
      ELSE BEGIN
         IF n = 9 THEN EatIsOn := TRUE ;
         IF n = 20 THEN RobIsOn := TRUE ;
         IF n = 22 THEN BEGIN
            GambleOn := TRUE ;
            Turns := 0 ;
         END ;
         IF n = 26 THEN DartsOn := TRUE ;
         IF n = 18 THEN BEGIN
            if info.DungeonEnable > 0 then DungeonOn := FALSE
              else
            DungeonOn := TRUE ;
            { look out point }
            WriteDisplay(11,'You''re kicking back at the Look Out Point.') ;
            repeat
               fall := random(100) ;
            until (fall > 4) and (fall < 9) ;
            falling := fall = 5 ;
         END ;
         IF n = SecretSquare THEN BEGIN
            WriteDisplay(14,'You landed on the SECRET SQUARE!  Awarding 1 turn and $250.') ;
            DEC(TurnCount) ;
            INC(PlayerScore,250) ;
            SecretSquare := 99 ;
         END ;
         IF (GameInfo.GameData[n].Owner <> '') AND
            (GameInfo.GameData[n].PurchasePrice > 0) AND
            (GameInfo.GameData[n].Owner <> Alias) THEN BEGIN
               { pay or play time }
               PayOrPlay ;
         END ELSE BEGIN
            IF PlayerSquareNumber <> 18 THEN ShowSpace ;
         END ;
      END ;
   END ; {case}
   ClearStatusArea ;
END ;


PROCEDURE NextTurn ;
VAR
   n   : BYTE ;
   i   : BYTE ;
   ch  : CHAR ;
BEGIN
   CASE PlayerSquareNumber OF
     18,22,26,9,20 : buttonchange := true ;
   END ;
   IF NumberOfPlayers < Info.StartingNumber THEN BEGIN
      ClearStatusArea ;
      CursorPos(20,1) ;
      sDisplay(0,14,1,'This game is not yet activated.  ') ;
      CursorPos(21,1) ;
      sDisplay(0,15,0,ItoA(Info.StartingNumber)+' players are required to activate this game.') ;
      Pause ;
      ClearStatusArea ;
      Exit ;
   END ELSE IF OutOfGame THEN BEGIN
      WriteDisplay(12,'You are OUT of this game!') ;
      ClearStatusArea ;
      Exit ;
   END ELSE IF TurnCount >= Info.TurnsPerGame THEN BEGIN
      WriteDisplay(12,'You have no turns left!') ;
      ClearStatusArea ;
      if not local then charout(#7) ;
      Exit ;
   END ELSE IF InJail THEN BEGIN
      IF (PlayerScore >= 50) OR (turncount >= 3) THEN BEGIN
         ResetButtons ;
         AddButton('T') ;
         AddButton('M') ;
         SendButtons(#13) ;
         buttonchange := true ;
         ClearStatusArea ;
         CursorPos(20,1) ;
         sDisplay(0,11,0,'It will cost $50 or 3 TURNS to get out of jail.') ;
         CursorPos(22,1) ;
         sDisplay(0,7,0,'Do you want to pay the bail in ') ;
         sdisplay(0,12,0,'T') ;
         sdisplay(0,7,0,'>urns or ') ;
         sdisplay(0,12,0,'M') ;
         sdisplay(0,7,0,'>oney: ') ;
         REPEAT
            ch := UPCASE(GetChar) ;
         UNTIL ch IN ['T','M'] ;
         sDisplay(0,15,0,ch) ;
         ClearStatus ;
         if ch = 'T' then begin
            if (Info.TurnsPerGame - TurnCount) < 3 then begin
               ClearStatusArea ;
               CursorPos(20,1) ;
               WriteDisplay(12,'You have less than 3 turns remaining.  Use money instead.') ;
               exit ;
            end else inc(TurnCount,3) ;
         end else begin
            if PlayerScore < 50 then begin
               WriteDisplay(12,'You have less than $50 remaining.  Use turns instead.') ;
               exit ;
            end else dec(PlayerScore,50) ;
         end ;
         InJail := FALSE ;
         { ReadThisGame(True) ; }
         PostScores(False) ;
         WriteDisplay(10,'You are now out of jail (just visiting).') ;
         Exit ;
      END ELSE BEGIN
         WriteDisplay(12,'You are stuck in jail!  Game over!') ;
         GameOver(50,False) ;
         Exit ;
      END ;
   END ;
   INC(TurnCount) ;

   N := RollDie ;
   FOR i := 1 TO n DO BEGIN
      INC(PlayerSquareNumber) ;
      IF PlayerSquareNumber > 33 THEN PlayerSquareNumber := 1 ;
      PutPlayer(PlayerSquareNumber) ;
      IF PlayerSquareNumber = 1 THEN BEGIN
         WriteDisplay(11,'Pay day!  You earn $500.') ;
         INC(PlayerScore,500) ;
         { ReadThisGame(TRUE) ; }
         PostScores(False) ;
      END ;
      DELAY(100) ;
   END ;
   EvaluateSquare(PlayerSquareNumber) ;
   IF TurnCount > Info.TurnsPerGame THEN TurnCount := Info.TurnsPerGame ;
   IF NOT Info.MultiLine THEN BEGIN
      IF SavedScore <> PlayerScore THEN BEGIN
         SavedScore := PlayerScore ;
         { ReadThisGame(True) ; }
         PostScores(False) ;
      END ;
   END ELSE BEGIN
      { ReadThisGame(True) ; }
      PostScores(False) ;
   END ;
END ;




PROCEDURE AbortGame(Abort:BYTE) ;
BEGIN
   ClearScreen ;
   ResetButtons ;
   SendButtons(#13) ;
   buttonchange := true ;
   CASE Abort OF
      1 : GameScreen('ANSFILES\maxturns.ans') ;
      2 : GameScreen('ANSFILES\OutOfGam.ans') ;
   END ;
   More('Press <any key> to continue',12) ;
END ;


FUNCTION GetPlayerNumber : BYTE ;
VAR
   temp,
   i,j     : BYTE ;
BEGIN
   fn := 'EA.GAM' ;
   ASSIGN(GameFile,fn) ;
   RESET(GameFile) ;
   SEEK(GameFile,GameNumber-1) ;
   READGame ;
   CLOSE(GameFile) ;
   j := 0 ;
   FOR i := 1 TO 8 DO BEGIN
      IF GameInfo.PlayerName[i] = Alias THEN temp := i ;
      IF GameInfo.PlayerName[i] <> '' THEN INC(j) ;
   END ;
   NumberOfPlayers := j ;
   GetPlayerNumber := temp ;
END ;


FUNCTION EnterGame : BOOLEAN ;
VAR
   i     : BYTE ;
BEGIN
   fn := 'EA.GAM' ;
   ASSIGN(GameFile,fn) ;
   RESET(GameFile) ;
   SEEK(GameFile,GameNumber-1) ;
   READGame ;
   GameInUse := GameInfo.InUse ;
   IF GameInUse THEN BEGIN
      CLOSE(GameFile) ;
      EnterGame := FALSE ;
      Exit ;
   END ;
   IF LastDate <> Date THEN BEGIN
      LastDate := Date ;
      TurnCount := 0 ;
      SEEK(GameFile,GameNumber-1) ;
      WRITEGame ;
   END ;
   CLOSE(GameFile) ;
   IF OutOfGame THEN BEGIN
      AbortGame(2) ;
      EnterGame := FALSE ;
      Exit ;
   END ;
   IF TurnCount >= Info.TurnsPerGame THEN BEGIN
      AbortGame(1) ;
      EnterGame := FALSE ;
      Exit ;
   END ;
   EnterGame := TRUE ;
END ;


PROCEDURE Look ;
BEGIN
   ShowText(ItoA(PlayerSquareNumber)) ;
   ShowSpace ;
   RedisplayInnerBoard ;
   PostScores(True) ;
END ;


PROCEDURE Gamble ;
VAR
   TempStr   : STRING ;
   Tval      : LONGINT ;
   Rand      : INTEGER ;
   k         : INTEGER ;
   kstr      : STRING ;
BEGIN
   ClearStatusArea ;
   ResetButtons ;
   for k := 0 to 9 do begin
      str(k,kstr) ;
      AddButton(kstr[1]) ;
   end ;
   SendButtons(#13) ;
   buttonchange := true ;
   IF PlayerScore < 1 THEN BEGIN
      Say(1,'You do not have any cash to wager!') ;
      Pause ;
      Exit ;
   END ;
   REPEAT
      Say(1,'You are gambling in the CASINO with '+ItoA((Info.MaxGambles-Turns))+
            ' gambles left...') ;
      Say(2,'The odds are 50/50 here.') ;
      Say(3,'Enter the amount to gamble [$1..$'+ItoA(PlayerScore)+']: ') ;
      TempStr := GetInput('',1,Length(ItoA(PlayerScore))) ;
      IF TempStr = '' THEN TempStr := '0' ;
   UNTIL (AtoI(TempStr) >= 0) AND
         (AtoI(TempStr) <= playerscore) ;
   Tval := AtoI(TempStr) ;
   IF Tval = 0 THEN Exit ;
   Rand := Random(10003) ;
   ClearStatusArea ;
   If Odd(rand) then begin
      Say(1,'You lose!') ;
      Say(3,'You lost $'+TempStr+' bucks!') ;
      Dec(PlayerScore,Tval) ;
   End Else Begin
      Say(1,'You win!') ;
      Say(3,'You won $'+TempStr+' bucks!') ;
      Inc(PlayerScore,Tval) ;
   End ;
   INC(Turns) ;
   GambleOn := Turns < Info.MaxGambles ;
   PostScores(False) ;
   Pause ;
   buttonchange := true ;
END ;




PROCEDURE PlayMenu ;
VAR
   tstr    : STRING ;
   ch      : CHAR ;
BEGIN
   InAGame := TRUE ;
   buttonchange := true ;
   REPEAT
      ClearStatusArea ;
      ResetButtons ;
      CursorPos(20,1) ;
      WriteBar('Time: '+ItoA(TimeRemaining)+'   Turns: '+
               ItoA((Info.TurnsPerGame-TurnCount))+
               '   Cash: $'+CommaStr(PlayerScore)+
               '   Days Remaining: '+ItoA(DaysLeft)) ;
      CursorPos(21,1) ;
      IF (PlayerSquareNumber = 18) AND (DungeonOn) THEN BEGIN
        sDisplay(0,14,1,'<D>ungeon           ') ;
        AddButton('D') ;
        buttonchange := true ;
      END ;
      IF (PlayerSquareNumber = 22) AND (GambleOn) THEN BEGIN
        sDisplay(0,14,1,'<G>amble            ') ;
        AddButton('G') ;
        buttonchange := true ;
      END ;
      IF (PlayerSquareNumber = 26) AND (DartsOn) THEN BEGIN
        sDisplay(0,14,1,'<B>ar Darts         ') ;
        AddButton('B') ;
        buttonchange := true ;
      END ;
      IF (PlayerSquareNumber = 9) AND (EatIsOn) THEN BEGIN
        sDisplay(0,14,1,'<E>at Food          ') ;
        AddButton('E') ;
        buttonchange := true ;
      END ;
      IF (PlayerSquareNumber = 20) AND (PlayerScore > 99) AND (RobIsOn) THEN BEGIN
        sDisplay(0,14,1,'<R>ob Bank          ') ;
        AddButton('R') ;
        buttonchange := true ;
      END ;
      sDisplay(0,11,0,'<P>roperty Summary  ') ;
      AddButton('P') ;
      sDisplay(0,12,0,'<L>ook              ') ;
      AddButton('L') ;
      sDisplay(0,13,0,'<S>how Space') ;
      AddButton('S') ;
      CursorPos(22,1) ;
      sDisplay(0,9,0,'<M>arket            ') ;
      AddButton('M') ;
      sDisplay(0,11,0,'<') ;
      sDisplay(0,14,0,'T') ;
      sDisplay(0,11,0,'>ake a Turn       ') ;
      AddButton('T') ;
      sDisplay(0,10,0,'<Y>our Stats        ') ;
      AddButton('Y') ;
      sDisplay(0,13,0,'<Q>uit: ') ;
      AddButton('Q') ;
      if buttonchange then begin
         SendButtons(#13) ;
         buttonchange := false ;
      end ;
      REPEAT
         IF (PlayerSquareNumber=18) AND (falling) AND (DungeonOn) THEN ch := 'D'
           else
         ch := UpCase(GetChar) ;
         IF (ch='D') AND ((PlayerSquareNumber<>18) OR (NOT DungeonOn)) THEN ch := 'z' ;
         IF (ch='G') AND ((PlayerSquareNumber<>22) OR (NOT GambleOn)) THEN ch := 'z' ;
         IF (ch='B') AND ((PlayerSquareNumber<>26) OR (NOT DartsOn)) THEN ch := 'z' ;
         IF (ch='E') AND ((PlayerSquareNumber<>9) OR (NOT EatIsOn)) THEN ch := 'z' ;
         IF (ch='R') AND ((PlayerSquareNumber<>20) OR (PlayerScore < 100)
                         OR (NOT RobIsOn)) THEN ch := 'z' ;
         IF ch = #13 THEN ch := 'T' ;
      UNTIL ch IN [#18,'B','D','E','L','G','P','R','S','T','Q','M','Y'] ;
      IF ch = 'Q' THEN sDisplay(0,14,0,'BYE!') ELSE sDisplay(0,14,0,'OK') ;
      CASE ch OF
         'R' : RobBank ;
         'E' : BEGIN
                  EatIsOn := FALSE ;
                  ClearStatusArea ;
                  WriteMsg(10,'Enjoying the meal, your strength builds.  You gain an extra turn!') ;
                  DEC(TurnCount) ;
                  buttonchange := true ;
                  Pause ;
               END ;
         'B' : BEGIN
                  ResetButtons ;
                  AddButton('Q') ;
                  AddButton('U') ;
                  AddButton('D') ;
                  SendButtons(#13) ;
                  buttonchange := true ;
                  PlayDarts ;
                  { ReadThisGame(True) ; }
                  RedisplayInnerBoard ;
                  PostScores(true) ;
                  DartsOn := FALSE ;
               END ;
         'D' : BEGIN
                  ResetButtons ;
                  AddButton('U') ;
                  AddButton('D') ;
                  AddButton('L') ;
                  AddButton('R') ;
                  AddButton('Q') ;
                  SendButtons(#13) ;
                  buttonchange := true ;
                  PlayDungeon(falling) ;
                  RedisplayInnerBoard ;
                  PostScores(true) ;
                  WriteNumbers ;
                  DungeonOn := FALSE ;
               END ;
         'L' : Look ;
         'G' : Gamble ;
         'P' : BEGIN
                  PropertySummary(GameNumber) ;
                  DrawBoard ;
                  PostScores(true) ;
               END ;
         'S' : ShowSpace ;
         'T' : NextTurn ;
         'M' : BEGIN
                  Market ;
                  DrawBoard ;
                  PostScores(true) ;
               END ;
         'Y' : ShowPropertiesHeld ;
         #18 : BEGIN
                  DrawBoard ;
                  PostScores(true) ;
               END ;
      END ;
   UNTIL ch = 'Q' ;
   InAGame := FALSE ;
END ;

PROCEDURE GetSecretSquare ;
VAR
   i     : BYTE ;
   Done  : BOOLEAN ;
BEGIN
   REPEAT
      REPEAT
         i := Random(200) ;
      UNTIL (i > 0) AND (i < 33) ;
      CASE i OF
         1,5,13,14,15,16,17,18,23,29,31 : Done := FALSE ;
         ELSE Done := TRUE ;
      END ;
   UNTIL Done ;
   SecretSquare := i ;
END ;


PROCEDURE PlayGame(GNum:BYTE) ;
VAR
   j   : BYTE ;
BEGIN
   DrawFull := FALSE ;
   EatIsOn := FALSE ;
   RobIsOn := FALSE ;
   DartsOn := FALSE ;
   DungeonOn := FALSE ;
   REPEAT
      j := Random(200) ;
   UNTIL (j > 0) AND (j < 6) ;
   EABoardName := 'ANSFILES\EBoard' + ItoA(j) + '.ANS' ;
   IF NOT Exist(EABoardName) THEN EABoardName := 'ANSFILES\EBOARD.ANS' ;
   GameNumber := GNum ;
   PlayerNumber := GetPlayerNumber ;
   PopulateGlobals ;
   IF EnterGame THEN BEGIN
      GameInfo.InUse := TRUE ;
      WriteThisGame ;
      GetSecretSquare ;
      DrawBoard ;
      PostScores(True) ;
      PlayMenu ;
      GameInfo.InUse := FALSE ;
      WriteThisGame ;
   END ELSE IF GameInUse THEN BEGIN
      CRLF ;
      sDisplay(0,12,0,'That game is being played on another node.  Try again later.') ;
      Crlf ;
      More('Press <any key> to continue',11) ;
   END ;
END ;


PROCEDURE ViewTournament ;
VAR
   i,x,w      : BYTE ;  { i is # games running }
   total      : BYTE ;
   Tfile,Afile: TEXT ;
   counter    : BYTE ;
   textname,
   ansiname   : STRING ;
   ch         : char ;
   DTG        : string ;
   sarray     : array [1..10] of string ;
   garray     : array [1..10] of string ;
   tstr       : string ;
BEGIN
   IF NOT Exist('EA.TRN') THEN BEGIN
      Crlf ;
      Display(0,12,0,'There is no tournament file!') ;
      Crlf ;
      More('Press <any key> to continue',14) ;
      Exit ;
   END ;
   counter := 0 ;
   IF Info.MultiLine THEN BEGIN
      IF Activity(Info.CommDrive,2) THEN BEGIN
         CRLF ;
         Display(0,10,0,'Another node is processing the tournament listing.') ;
         CRLF ;
         sDisplay(0,14,1,'Please stand by...') ;
         REPEAT
            DELAY(5000) ;
            sDisplay(0,14,0,'.') ;
            INC(counter) ;
            chkconnect ;
            if counter > 6 then clearactivity(Info.CommDrive,2) ;
         UNTIL NOT Activity(Info.CommDrive,2) ;
         CRLF ; CRLF ;
         Display(0,10,0,'Continuing') ;
      END ;
   END ;
   SetActivity(Info.CommDrive,UserName,2) ;
   IF Info.TextBull = '' THEN textname := 'EA.BBS'
     ELSE textname := Info.TextBull ;
   IF Info.AnsiBull = '' THEN ansiname := 'EA.SCR'
     ELSE ansiname := Info.AnsiBull ;
   alltime.totalscore := 0 ;
   alltime.gameswon := 0 ;
   IF EXIST('alltime.dat') THEN BEGIN
      assign(alltimefile,'alltime.dat') ;
      reset(alltimefile) ;
      read(alltimefile,alltime) ;
      close(alltimefile) ;
   END ;
   for x := 1 to 10 do begin
      garray[x] := '' ;
      sarray[x] := '' ;
   end ;
   EaSort(1) ;
   fn := 'EA.TRN' ;
   ASSIGN(TournFile,fn) ;
   RESET(TournFile) ;
   i := 0 ;
   if filesize(TournFile) > 0 then begin
      WHILE NOT EOF(TournFile) DO BEGIN
         READ(TournFile,Tourn) ;
         INC(i) ;
         if i < 11 then begin
            sarray[i] := ljust(copy(tourn.name,1,25),25) +
                         '    ' + rjust('$'+commastr(tourn.totalscore),8) ;
            total := i ;
         end else seek(tournfile,filesize(tournfile)) ;
      END ;
   end ;
   CLOSE(TournFile) ;
   EaSort(2) ;
   fn := 'EA.TRN' ;
   ASSIGN(TournFile,fn) ;
   RESET(TournFile) ;
   i := 0 ;
   if filesize(TournFile) > 0 then begin
      WHILE NOT EOF(TournFile) DO BEGIN
         READ(TournFile,Tourn) ;
         INC(i) ;
         if i < 11 then garray[i] := ljust(copy(tourn.name,1,25),25) +
                                     '    ' +
                                     center(commastr(tourn.gameswon),9)
           else
         seek(tournfile,filesize(tournfile)) ;
      END ;
   end ;
   CLOSE(TournFile) ;
   GetDate(yr,mn,dt,dy) ;
   yr := yr - 1900 ;
   DTG := fixbyte(mn)+'-'+fixbyte(dt)+'-'+ItoA(yr) ;
   ASSIGN(Tfile,textname) ;
   REWRITE(Tfile) ;
   ASSIGN(Afile,ansiname) ;
   REWRITE(Afile) ;
   WRITELN(Tfile,'') ;
   WRITELN(Tfile,'                    Eclectic Avenue - Top Ten Player Scores                   ') ;
   WRITELN(Afile,'') ;
   WRITELN(Afile,AnsString(1,15,0,'                    Eclectic Avenue - Top Ten Player Scores                   ')) ;
   WRITELN(Tfile,MkString(78,'')) ;
   WRITELN(Afile,AnsString(0,15,0,MkString(78,''))) ;
   IF alltime.totalscore > 0 THEN BEGIN
      WRITELN(Tfile,Center('All-Time Cash Scorer as of '+DTG+': '+alltime.name+' - '+
                    '$'+CommaStr(alltime.totalscore),78)) ;
      WRITELN(Afile,AnsString(0,11,0,Center('All-Time Cash Scorer as of '+DTG+': '+alltime.name+' - '+
                    '$'+CommaStr(alltime.totalscore),78))) ;
   END ;
   IF alltime.gameswon > 0 THEN BEGIN
      WRITELN(Tfile,Center('All-Time Game Scorer as of '+DTG+': '+alltime.gamename+' - '+
                    CommaStr(alltime.gameswon),78)) ;
      WRITELN(Afile,AnsString(0,11,0,Center('All-Time Game Scorer as of '+DTG+': '+alltime.gamename+' - '+
                    CommaStr(alltime.gameswon)+' games',78))) ;
   END ;
   IF i = 0 THEN BEGIN
      Crlf ;
      WRITELN(Tfile,MkString(78,'')) ;
      WRITELN(Afile,AnsString(0,15,0,MkString(78,''))) ;
      WRITELN(Tfile) ;
      WRITELN(Afile) ;
      Display(0,12,0,'There are no games running!') ;
      WRITELN(Tfile,'There are no games running!') ;
      WRITELN(Afile,AnsString(0,12,0,'There are no games running!')) ;
      WRITELN(Tfile) ;
      WRITELN(Afile) ;
      FLUSH(Afile) ;
      FLUSH(Tfile) ;
      CLOSE(Afile) ;
      CLOSE(Tfile) ;
      SetActivity(Info.CommDrive,UserName,1) ;
      crlf ;
      more('Press [any key] to continue',10) ;
      EXIT ;
   END ;
   WRITELN(Tfile,MkString(38,'') + '' + MkString(39,'')) ;
   WRITELN(Afile,AnsString(0,15,0,MkString(38,'')) + '' + MkString(39,'')) ;
   tstr := '' ;
   tstr := '     Scores For Games In Progress           Existing Game Wins History' ;
   writeln(tfile,tstr) ;
   tstr := '' ;
   tstr := AnsString(4,15,0,'     Scores For Games In Progress     ') ;
   tstr := tstr + AnsString(0,15,0,'') ;
   tstr := tstr + AnsString(4,15,0,'      Existing Game Wins History       ') ;
   writeln(afile,tstr) ;
   tstr := MkString(38,'')+''+MkString(39,'') ;
   writeln(tfile,tstr) ;
   writeln(afile,ansString(0,15,0,tstr)) ;
   tstr := '' ;
   tstr := '       Player Name             Score          Player Name           Games Won' ;
   writeln(tfile,tstr) ;
   tstr := '' ;
   tstr := ansString(5,15,0,'       Player Name       ') ;
   tstr := tstr + ansString(0,15,0,'    ') ;
   tstr := tstr + ansString(3,15,0,'  Score ') ;
   tstr := tstr + ansString(0,15,0,'  ') ;
   tstr := tstr + ansString(5,15,0,'       Player Name       ') ;
   tstr := tstr + ansString(0,15,0,'    ') ;
   tstr := tstr + ansString(3,15,0,'Games Won') ;
   writeln(afile,tstr) ;
   FOR w := 1 TO total DO BEGIN
      tstr := '' ;
      tstr := sarray[w] + '  ' + garray[w] ;
      writeln(tfile,tstr) ;
      tstr := '' ;
      if pos('No One',sarray[w]) > 0 then
         tstr := ansString(0,8,0,sarray[w])
      else
         tstr := ansString(0,12,0,sarray[w]) ;
      tstr := tstr + ansString(0,15,0,'  ') ;
      if pos('No One',garray[w]) > 0 then
         tstr := tstr + ansString(0,8,0,garray[w])
      else
         tstr := tstr + ansString(0,10,0,garray[w]) ;
      writeln(afile,tstr) ;
   END ;
   WRITELN(Tfile,MkString(38,'') + '' + MkString(38,'')) ;
   WRITELN(Afile,AnsString(0,15,0,MkString(38,'')) + '' + MkString(39,'')) ;
   if rip then setRIPdefault
     else ClearScreen ;

   FLUSH(Tfile) ;
   CLOSE(Tfile) ;
   FLUSH(Afile) ;
   CLOSE(Afile) ;
   Crlf ;
   SetActivity(Info.CommDrive,UserName,1) ;
{  jp_setfattr := false ; }
   GameScreen(ansiname) ;
{  jp_setfattr := true ;  }
   if not rip then Space else ch := getchar ;
END ;



BEGIN
   falling := false ;
   buttonchange := true ;
   lastlistpos := 0 ;
   { main }
END.
